import { SUPPORTED_COMMERCE_OBJECTS, ACTION_SUPPORTED_COMMERCE_OBJECTS, TRIGGER_SUPPORTED_COMMERCE_OBJECTS, actionUiTypesMap, triggerUiTypesMap, } from './constants.js';
import { AbortError } from '@shopify/cli-kit/node/error';
import { capitalize } from '@shopify/cli-kit/common/string';
const actionTypesToUiTypes = new Map(actionUiTypesMap);
const triggerTypesToUiTypes = new Map(triggerUiTypesMap);
export const serializeConfigField = (field, type) => {
    const typesToUiTypes = type === 'flow_action' ? actionTypesToUiTypes : triggerTypesToUiTypes;
    const uiType = typesToUiTypes.get(field.type);
    if (typeof field.key !== 'string') {
        throw new AbortError(`key property must be specified for non-commerce object fields in ${JSON.stringify(field)}`);
    }
    if (!uiType) {
        throw new AbortError(`Field type ${field.type} is not supported on Flow ${type === 'flow_action' ? 'Actions' : 'Triggers'}`);
    }
    const serializedField = {
        name: field.key,
        description: field.description,
        uiType,
    };
    if (type === 'flow_action') {
        serializedField.label = field.name;
        serializedField.required = field.required;
    }
    return serializedField;
};
export const serializeCommerceObjectField = (field, type) => {
    if (type === 'flow_trigger' && !TRIGGER_SUPPORTED_COMMERCE_OBJECTS.includes(field.type)) {
        throw new AbortError(`Commerce object ${field.type} is not supported for Flow Triggers`);
    }
    if (type === 'flow_action' && !ACTION_SUPPORTED_COMMERCE_OBJECTS.includes(field.type)) {
        throw new AbortError(`Commerce object ${field.type} is not supported for Flow Actions`);
    }
    const commerceObject = field.type.replace('_reference', '');
    const serializedField = {
        name: `${commerceObject}_id`,
        uiType: type === 'flow_action' ? 'commerce-object-id' : commerceObject,
        description: field.description,
    };
    if (type === 'flow_action') {
        serializedField.label = `${capitalize(commerceObject)} ID`;
        serializedField.required = field.required;
    }
    return serializedField;
};
export const serializeFields = (type, fields) => {
    if (!fields)
        return [];
    const serializedFields = fields.map((field) => {
        if (Object.keys(SUPPORTED_COMMERCE_OBJECTS).includes(field.type)) {
            return serializeCommerceObjectField(field, type);
        }
        return serializeConfigField(field, type);
    });
    return serializedFields;
};
//# sourceMappingURL=serialize-fields.js.map