import { ExtensionAssetBuildStatus } from './payload/models.js';
import { GetUIExtensionPayloadOptions } from './payload.js';
import { ExtensionInstance } from '../../../models/extensions/extension-instance.js';
export type Locale = string;
export interface Localization {
    defaultLocale: Locale;
    translations: {
        [key: Locale]: {
            [key: string]: string;
        };
    };
    lastUpdated: number;
}
export declare function getLocalizationFilePaths(extension: ExtensionInstance): Promise<string[]>;
export declare function getLocalization(extension: ExtensionInstance, options: GetUIExtensionPayloadOptions): Promise<{
    localization: Localization | undefined;
    status: ExtensionAssetBuildStatus;
}>;
