import { LocalSource, RemoteSource } from './identifiers.js';
import { LocalRemoteSource } from './id-matching.js';
import { IdentifiersExtensions } from '../../models/app/identifiers.js';
import { DeploymentMode } from '../deploy/mode.js';
export declare function matchConfirmationPrompt(local: LocalSource, remote: RemoteSource, type?: 'extension' | 'function'): Promise<boolean>;
export declare function selectRemoteSourcePrompt(localSource: LocalSource, remoteSourcesOfSameType: RemoteSource[], remoteIdField: 'id' | 'uuid'): Promise<RemoteSource>;
export interface SourceSummary {
    appTitle: string | undefined;
    question: string;
    identifiers: IdentifiersExtensions;
    toCreate: LocalSource[];
    onlyRemote: RemoteSource[];
    dashboardOnly: RemoteSource[];
}
export declare function deployConfirmationPrompt({ appTitle, question, identifiers, toCreate, onlyRemote, dashboardOnly }: SourceSummary, deploymentMode: DeploymentMode, apiKey: string, token: string): Promise<boolean>;
export declare function extensionMigrationPrompt(toMigrate: LocalRemoteSource[], includeRemoteType?: boolean): Promise<boolean>;
