import { getAppScopes } from '../../../models/app/app.js';
import { fetchAppFromConfigOrSelect } from '../fetch-app-from-config-or-select.js';
import { outputContent, outputToken } from '@shopify/cli-kit/node/output';
export async function showEnv(app) {
    return outputEnv(app, 'text');
}
export async function outputEnv(app, format) {
    const orgApp = await fetchAppFromConfigOrSelect(app);
    if (format === 'json') {
        return outputContent `${outputToken.json({
            SHOPIFY_API_KEY: orgApp.apiKey,
            SHOPIFY_API_SECRET: orgApp.apiSecretKeys[0]?.secret,
            SCOPES: getAppScopes(app.configuration),
        })}`;
    }
    else {
        return outputContent `
    ${outputToken.green('SHOPIFY_API_KEY')}=${orgApp.apiKey}
    ${outputToken.green('SHOPIFY_API_SECRET')}=${orgApp.apiSecretKeys[0]?.secret ?? ''}
    ${outputToken.green('SCOPES')}=${getAppScopes(app.configuration)}
  `;
    }
}
//# sourceMappingURL=show.js.map