import { zod } from '@shopify/cli-kit/node/schema';
export type FunctionConfigType = zod.infer<typeof FunctionExtensionSchema>;
export declare const FunctionExtensionSchema: zod.ZodObject<{
    type: zod.ZodString;
    name: zod.ZodString;
    metafields: zod.ZodDefault<zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        namespace: zod.ZodString;
        key: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>>;
    description: zod.ZodOptional<zod.ZodString>;
    handle: zod.ZodOptional<zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>>;
    extension_points: zod.ZodOptional<zod.ZodAny>;
    capabilities: zod.ZodOptional<zod.ZodObject<{
        network_access: zod.ZodOptional<zod.ZodBoolean>;
        block_progress: zod.ZodOptional<zod.ZodBoolean>;
        api_access: zod.ZodOptional<zod.ZodBoolean>;
    }, "strip", zod.ZodTypeAny, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    }, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    }>>;
    categories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
    settings: zod.ZodOptional<zod.ZodObject<{
        fields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
            key: zod.ZodOptional<zod.ZodString>;
            name: zod.ZodOptional<zod.ZodString>;
            description: zod.ZodOptional<zod.ZodString>;
            required: zod.ZodOptional<zod.ZodBoolean>;
            type: zod.ZodString;
            validations: zod.ZodOptional<zod.ZodArray<zod.ZodAny, "many">>;
        }, "strip", zod.ZodTypeAny, {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }, {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }>, "many">>;
    }, "strip", zod.ZodTypeAny, {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    }, {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    }>>;
    build: zod.ZodObject<{
        command: zod.ZodOptional<zod.ZodEffects<zod.ZodString, string | undefined, string>>;
        path: zod.ZodOptional<zod.ZodString>;
        watch: zod.ZodOptional<zod.ZodUnion<[zod.ZodString, zod.ZodArray<zod.ZodString, "many">]>>;
    }, "strip", zod.ZodTypeAny, {
        command?: string | undefined;
        path?: string | undefined;
        watch?: string | string[] | undefined;
    }, {
        command?: string | undefined;
        path?: string | undefined;
        watch?: string | string[] | undefined;
    }>;
    configuration_ui: zod.ZodDefault<zod.ZodOptional<zod.ZodBoolean>>;
    ui: zod.ZodOptional<zod.ZodObject<{
        enable_create: zod.ZodOptional<zod.ZodBoolean>;
        paths: zod.ZodOptional<zod.ZodObject<{
            create: zod.ZodString;
            details: zod.ZodString;
        }, "strip", zod.ZodTypeAny, {
            create: string;
            details: string;
        }, {
            create: string;
            details: string;
        }>>;
    }, "strip", zod.ZodTypeAny, {
        enable_create?: boolean | undefined;
        paths?: {
            create: string;
            details: string;
        } | undefined;
    }, {
        enable_create?: boolean | undefined;
        paths?: {
            create: string;
            details: string;
        } | undefined;
    }>>;
    api_version: zod.ZodString;
    input: zod.ZodOptional<zod.ZodObject<{
        variables: zod.ZodOptional<zod.ZodObject<{
            namespace: zod.ZodString;
            key: zod.ZodString;
        }, "strip", zod.ZodTypeAny, {
            namespace: string;
            key: string;
        }, {
            namespace: string;
            key: string;
        }>>;
    }, "strip", zod.ZodTypeAny, {
        variables?: {
            namespace: string;
            key: string;
        } | undefined;
    }, {
        variables?: {
            namespace: string;
            key: string;
        } | undefined;
    }>>;
    targeting: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        target: zod.ZodString;
        input_query: zod.ZodOptional<zod.ZodString>;
        export: zod.ZodOptional<zod.ZodString>;
    }, "strip", zod.ZodTypeAny, {
        target: string;
        input_query?: string | undefined;
        export?: string | undefined;
    }, {
        target: string;
        input_query?: string | undefined;
        export?: string | undefined;
    }>, "many">>;
}, "strip", zod.ZodTypeAny, {
    type: string;
    name: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    api_version: string;
    build: {
        command?: string | undefined;
        path?: string | undefined;
        watch?: string | string[] | undefined;
    };
    configuration_ui: boolean;
    description?: string | undefined;
    handle?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    } | undefined;
    categories?: string[] | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
    ui?: {
        enable_create?: boolean | undefined;
        paths?: {
            create: string;
            details: string;
        } | undefined;
    } | undefined;
    input?: {
        variables?: {
            namespace: string;
            key: string;
        } | undefined;
    } | undefined;
    targeting?: {
        target: string;
        input_query?: string | undefined;
        export?: string | undefined;
    }[] | undefined;
}, {
    type: string;
    name: string;
    api_version: string;
    build: {
        command?: string | undefined;
        path?: string | undefined;
        watch?: string | string[] | undefined;
    };
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    description?: string | undefined;
    handle?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    } | undefined;
    categories?: string[] | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
    configuration_ui?: boolean | undefined;
    ui?: {
        enable_create?: boolean | undefined;
        paths?: {
            create: string;
            details: string;
        } | undefined;
    } | undefined;
    input?: {
        variables?: {
            namespace: string;
            key: string;
        } | undefined;
    } | undefined;
    targeting?: {
        target: string;
        input_query?: string | undefined;
        export?: string | undefined;
    }[] | undefined;
}>;
declare const spec: import("../specification.js").ExtensionSpecification<{
    type: string;
    name: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    api_version: string;
    build: {
        command?: string | undefined;
        path?: string | undefined;
        watch?: string | string[] | undefined;
    };
    configuration_ui: boolean;
    description?: string | undefined;
    handle?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    } | undefined;
    categories?: string[] | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
    ui?: {
        enable_create?: boolean | undefined;
        paths?: {
            create: string;
            details: string;
        } | undefined;
    } | undefined;
    input?: {
        variables?: {
            namespace: string;
            key: string;
        } | undefined;
    } | undefined;
    targeting?: {
        target: string;
        input_query?: string | undefined;
        export?: string | undefined;
    }[] | undefined;
}>;
export default spec;
