import { BaseConfigType } from './schemas.js';
import { ExtensionFeature, ExtensionSpecification } from './specification.js';
import { ExtensionBuildOptions } from '../../services/build/extension.js';
import { Identifiers } from '../app/identifiers.js';
/**
 * Class that represents an instance of a local extension
 * Before creating this class we've validated that:
 * - There is a spec for this type of extension
 * - The Schema for that spec is followed by the extension config toml file
 * - We were able to find an entry point file for that extension
 *
 * It supports extension points, making this Class compatible with both new ui-extension
 * and legacy extension types. Extension points are optional and this class will handle them if present.
 *
 * This class holds the public interface to interact with extensions
 */
export declare class ExtensionInstance<TConfiguration extends BaseConfigType = BaseConfigType> {
    entrySourceFilePath: string;
    devUUID: string;
    localIdentifier: string;
    idEnvironmentVariableName: string;
    directory: string;
    configuration: TConfiguration;
    configurationPath: string;
    outputPath: string;
    handle: string;
    specification: ExtensionSpecification;
    private useExtensionsFramework;
    get graphQLType(): any;
    get type(): string;
    get humanName(): string;
    get name(): string;
    get dependency(): string | undefined;
    get externalType(): string;
    get surface(): string;
    get isPreviewable(): boolean;
    get isThemeExtension(): boolean;
    get isFunctionExtension(): boolean;
    get isESBuildExtension(): boolean;
    get features(): ExtensionFeature[];
    get outputFileName(): string;
    set usingExtensionsFramework(value: boolean);
    constructor(options: {
        configuration: TConfiguration;
        configurationPath: string;
        entryPath?: string;
        directory: string;
        specification: ExtensionSpecification;
    });
    isDraftable(unifiedDeployment: boolean): boolean;
    deployConfig({ apiKey, token, unifiedDeployment, }: ExtensionDeployConfigOptions): Promise<{
        [key: string]: unknown;
    } | undefined>;
    validate(): Promise<import("@shopify/cli-kit/node/result").Result<unknown, string>>;
    preDeployValidation(): Promise<void>;
    buildValidation(): Promise<void>;
    publishURL(options: {
        orgId: string;
        appId: string;
        extensionId?: string;
    }): Promise<string>;
    getBundleExtensionStdinContent(): string;
    shouldFetchCartUrl(): boolean;
    hasExtensionPointTarget(target: string): boolean;
    get buildCommand(): string | undefined;
    get watchPaths(): string[] | null;
    get inputQueryPath(): string;
    get isJavaScript(): boolean;
    build(options: ExtensionBuildOptions): Promise<void>;
    buildForBundle(options: ExtensionBuildOptions, identifiers: Identifiers, bundleDirectory: string): Promise<void>;
    bundleConfig({ identifiers, token, apiKey, unifiedDeployment }: ExtensionBundleConfigOptions): Promise<{
        uuid: string;
        config: string;
        context: string;
    } | undefined>;
}
export interface ExtensionDeployConfigOptions {
    apiKey: string;
    token: string;
    unifiedDeployment: boolean;
}
export interface ExtensionBundleConfigOptions {
    identifiers: Identifiers;
    token: string;
    apiKey: string;
    unifiedDeployment: boolean;
}
