import { AppInterface } from './app.js';
import { ExtensionTemplate } from './template.js';
import { RemoteSpecification } from '../../api/graphql/extension_specifications.js';
import { ExtensionInstance } from '../extensions/extension-instance.js';
import { FunctionConfigType } from '../extensions/specifications/function.js';
import { OrganizationApp } from '../organization.js';
export declare const DEFAULT_CONFIG: {
    application_url: string;
    client_id: string;
    name: string;
    webhooks: {
        api_version: string;
    };
    embedded: boolean;
    access_scopes: {
        scopes: string;
    };
};
export declare function testApp(app?: Partial<AppInterface>, schemaType?: 'current' | 'legacy'): AppInterface;
interface TestAppWithConfigOptions {
    app?: Partial<AppInterface>;
    config: object;
}
export declare function testAppWithLegacyConfig({ app, config }: TestAppWithConfigOptions): AppInterface;
export declare function testAppWithConfig(options?: TestAppWithConfigOptions): AppInterface;
export declare function testOrganizationApp(app?: Partial<OrganizationApp>): OrganizationApp;
export declare function testUIExtension(uiExtension?: Partial<ExtensionInstance>): Promise<ExtensionInstance>;
export declare function testThemeExtensions(directory?: string): Promise<ExtensionInstance>;
export declare function testWebPixelExtension(directory?: string): Promise<ExtensionInstance>;
export declare function testTaxCalculationExtension(directory?: string): Promise<ExtensionInstance>;
interface TestFunctionExtensionOptions {
    dir?: string;
    config?: FunctionConfigType;
    entryPath?: string;
    usingExtensionFramework?: boolean;
}
export declare function testFunctionExtension(opts?: TestFunctionExtensionOptions): Promise<ExtensionInstance<FunctionConfigType>>;
export declare const testRemoteSpecifications: RemoteSpecification[];
export declare const testRemoteExtensionTemplates: ExtensionTemplate[];
export declare const testLocalExtensionTemplates: ExtensionTemplate[];
export {};
