import { appFlags } from '../../../flags.js';
import Command from '../../../utilities/app-command.js';
import { loadAppConfiguration } from '../../../models/app/loader.js';
import { pushConfig } from '../../../services/app/config/push.js';
import { globalFlags } from '@shopify/cli-kit/node/cli';
import { Flags } from '@oclif/core';
class ConfigPush extends Command {
    async run() {
        const { flags } = await this.parse(ConfigPush);
        const { configuration, configurationPath } = await loadAppConfiguration({
            configName: flags.config,
            directory: flags.path,
        });
        await pushConfig({ configuration, configurationPath, force: flags.force });
    }
}
ConfigPush.description = 'Push your app configuration to the Partner Dashboard.';
ConfigPush.flags = {
    ...globalFlags,
    ...appFlags,
    force: Flags.boolean({
        hidden: false,
        description: 'Push configuration without asking for confirmation.',
        env: 'SHOPIFY_FLAG_FORCE',
        char: 'f',
        default: false,
    }),
};
export default ConfigPush;
//# sourceMappingURL=push.js.map