import { appFlags } from '../../../flags.js';
import link from '../../../services/app/config/link.js';
import Command from '../../../utilities/app-command.js';
import { Flags } from '@oclif/core';
import { globalFlags } from '@shopify/cli-kit/node/cli';
class ConfigLink extends Command {
    async run() {
        const { flags } = await this.parse(ConfigLink);
        const options = {
            commandConfig: this.config,
            directory: flags.path,
            apiKey: flags['client-id'],
        };
        await link(options);
    }
}
ConfigLink.description = 'Fetch your app configuration from the Partner Dashboard.';
ConfigLink.flags = {
    ...globalFlags,
    ...appFlags,
    'client-id': Flags.string({
        hidden: false,
        description: 'The Client ID of your app.',
        env: 'SHOPIFY_FLAG_CLIENT_ID',
    }),
};
export default ConfigLink;
//# sourceMappingURL=link.js.map