export declare const GetConfig: string;
export interface App {
    id: string;
    title: string;
    apiKey: string;
    organizationId: string;
    appType: string;
    grantedScopes: string[];
    applicationUrl: string;
    redirectUrlWhitelist: string[];
    webhookApiVersion: string;
    embedded: boolean;
    posEmbedded?: boolean;
    preferencesUrl?: string;
    requestedAccessScopes?: string[];
    gdprWebhooks?: {
        customerDeletionUrl?: string;
        customerDataRequestUrl?: string;
        shopDeletionUrl?: string;
    };
    appProxy?: {
        proxySubPath: string;
        proxySubPathPrefix: string;
        proxyUrl: string;
    };
}
export interface GetConfigQuerySchema {
    app: App;
    appProxy?: {
        subPath?: string;
        subPathPrefix?: string;
        url?: string;
    };
    preferencesUrl?: string;
}
