export declare const FindAppQuery: string;
export interface FindAppQuerySchema {
    app: {
        id: string;
        title: string;
        apiKey: string;
        organizationId: string;
        apiSecretKeys: {
            secret: string;
        }[];
        appType: string;
        grantedScopes: string[];
        betas?: {
            unifiedAppDeployment?: boolean;
            unifiedAppDeploymentOptIn?: boolean;
        };
        applicationUrl: string;
        redirectUrlWhitelist: string[];
        requestedAccessScopes?: string[];
        webhookApiVersion: string;
        embedded: boolean;
        posEmbedded?: boolean;
        preferencesUrl?: string;
        gdprWebhooks?: {
            customerDeletionUrl?: string;
            customerDataRequestUrl?: string;
            shopDeletionUrl?: string;
        };
        appProxy?: {
            subPath: string;
            subPathPrefix: string;
            url: string;
        };
        developmentStorePreviewEnabled: boolean;
    };
}
