import { gql } from 'graphql-request';
export const AppVersionsDiffQuery = gql `
  query AppVersionsDiff($apiKey: String!, $versionId: ID!) {
    app(apiKey: $apiKey) {
      versionsDiff(appVersionId: $versionId) {
        added {
          uuid
          registrationTitle
        }
        updated {
          uuid
          registrationTitle
        }
        removed {
          uuid
          registrationTitle
        }
      }
    }
  }
`;
//# sourceMappingURL=app_versions_diff.js.map