export declare const AppDeploy: string;
export interface AppModuleSettings {
    uuid: string;
    config: string;
    context: string;
}
export interface AppDeployVariables {
    apiKey: string;
    uuid: string;
    bundleUrl?: string;
    appModules?: AppModuleSettings[];
    skipPublish?: boolean;
    message?: string;
    versionTag?: string;
    commitReference?: string;
}
interface ErrorDetail {
    extension_id: number;
    extension_title: string;
}
export interface AppDeploySchema {
    appDeploy: {
        appVersion: {
            uuid: string;
            id: number;
            versionTag: string;
            location: string;
            message: string;
            appModuleVersions: {
                uuid: string;
                registrationUuid: string;
                validationErrors: {
                    field: string[];
                    message: string;
                }[];
            }[];
        };
        userErrors: {
            field: string[];
            message: string;
            category: string;
            details: ErrorDetail[];
        }[];
    };
}
export {};
