export interface AppBridgeAttributes {
}

interface AppBridgeConfig {
    host: string;
    apiKey: string;
    shop: string;
    locale: string;
    disabledFeatures?: [string];
}

export interface AppBridgeElements {
    'ui-nav-menu': {
        children?: any;
    };
    'ui-title-bar': {
        title?: string;
        children?: any;
    };
}

export type AugmentedElement<T extends keyof AugmentedElements> = AugmentedElements[T];

export interface AugmentedElements {
    button: MenuItemProperties;
    a: MenuItemProperties;
}

interface BaseResource extends Resource {
    variants?: Resource[];
}

interface Collection extends Resource {
    availablePublicationCount: number;
    description: string;
    descriptionHtml: string;
    handle: string;
    id: string;
    image?: Image_2 | null;
    productsAutomaticallySortedCount: number;
    productsCount: number;
    productsManuallySortedCount: number;
    publicationCount: number;
    ruleSet?: RuleSet | null;
    seo: {
        description?: string | null;
        title?: string | null;
    };
    sortOrder: CollectionSortOrder;
    storefrontId: string;
    templateSuffix?: string | null;
    title: string;
    updatedAt: string;
}

interface CollectionRule {
    column: string;
    condition: string;
    relation: string;
}

enum CollectionSortOrder {
    Manual = "MANUAL",
    BestSelling = "BEST_SELLING",
    AlphaAsc = "ALPHA_ASC",
    AlphaDesc = "ALPHA_DESC",
    PriceDesc = "PRICE_DESC",
    PriceAsc = "PRICE_ASC",
    CreatedDesc = "CREATED_DESC",
    Created = "CREATED",
    MostRelevant = "MOST_RELEVANT"
}

interface Environment {
    mobile: boolean;
    embedded: boolean;
    pos: boolean;
}

enum FulfillmentServiceType {
    GiftCard = "GIFT_CARD",
    Manual = "MANUAL",
    ThirdParty = "THIRD_PARTY"
}

interface Image_2 {
    id: string;
    altText?: string;
    originalSrc: string;
}

export interface MenuItemProperties {
    variant?: 'primary' | undefined;
}

type Money = string;

interface Product extends Resource {
    availablePublicationCount: number;
    createdAt: string;
    descriptionHtml: string;
    handle: string;
    hasOnlyDefaultVariant: boolean;
    images: Image_2[];
    options: {
        id: string;
        name: string;
        position: number;
        values: string[];
    }[];
    productType: string;
    publishedAt?: string | null;
    tags: string[];
    templateSuffix?: string | null;
    title: string;
    totalInventory: number;
    tracksInventory: boolean;
    variants: Partial<ProductVariant>[];
    vendor: string;
    updatedAt: string;
    status: ProductStatus;
}

enum ProductStatus {
    Active = "ACTIVE",
    Archived = "ARCHIVED",
    Draft = "DRAFT"
}

interface ProductVariant extends Resource {
    availableForSale: boolean;
    barcode?: string | null;
    compareAtPrice?: Money | null;
    createdAt: string;
    displayName: string;
    fulfillmentService?: {
        id: string;
        inventoryManagement: boolean;
        productBased: boolean;
        serviceName: string;
        type: FulfillmentServiceType;
    };
    image?: Image_2 | null;
    inventoryItem: {
        id: string;
    };
    inventoryManagement: ProductVariantInventoryManagement;
    inventoryPolicy: ProductVariantInventoryPolicy;
    inventoryQuantity?: number | null;
    position: number;
    price: Money;
    product: Partial<Product>;
    requiresShipping: boolean;
    selectedOptions: {
        value?: string | null;
    }[];
    sku?: string | null;
    taxable: boolean;
    title: string;
    weight?: number | null;
    weightUnit: WeightUnit;
    updatedAt: string;
}

enum ProductVariantInventoryManagement {
    Shopify = "SHOPIFY",
    NotManaged = "NOT_MANAGED",
    FulfillmentService = "FULFILLMENT_SERVICE"
}

enum ProductVariantInventoryPolicy {
    Deny = "DENY",
    Continue = "CONTINUE"
}

interface Resource {
    /** in GraphQL id format, ie 'gid://shopify/Product/1' */
    id: string;
}

interface ResourcePickerOptions {
    type: 'product' | 'variant' | 'collection';
    query?: string;
    selectionIds?: BaseResource[];
    action?: 'add' | 'select';
    multiple?: boolean | number;
    filter?: {
        hidden?: boolean;
        variants?: boolean;
        draft?: boolean | undefined;
        archived?: boolean | undefined;
    };
}

type ResourceSelection = Product | ProductVariant | Collection;

interface RuleSet {
    appliedDisjunctively: boolean;
    rules: CollectionRule[];
}

interface SelectPayload {
    readonly id?: string;
    selection: ResourceSelection[];
}

export interface ShopifyGlobal {
    config: AppBridgeConfig;
    origin: string;
    ready: Promise<void>;
    environment: Environment;
    loading(isLoading?: boolean): void;
    idToken(): Promise<string>;
    user(): Promise<User>;
    toast: {
        show(message: string, opts?: Partial<ToastOptions>): string;
        hide(id: string): void;
    };
    resourcePicker(options?: ResourcePickerOptions): Promise<SelectPayload | undefined>;
}

interface ToastOptions {
    duration: number;
    isError: boolean;
    action: string;
    onAction: () => void;
    onDismiss: () => void;
}

interface User {
    id: string;
    name: string;
    firstName?: string;
    lastName?: string;
    email: string;
    accountAccess: string;
    accountType: string;
}

enum WeightUnit {
    Kilograms = "KILOGRAMS",
    Grams = "GRAMS",
    Pounds = "POUNDS",
    Ounces = "OUNCES"
}

export { }
