import type {
  ShopifyGlobal,
  AugmentedElement,
  AppBridgeElements,
  AppBridgeAttributes,
} from './shopify';

export {ShopifyGlobal};

declare global {
  var shopify: ShopifyGlobal;

  // Install property augmentations onto DOM prototypes
  interface HTMLButtonElement extends AugmentedElement<'button'> {}
  interface HTMLAnchorElement extends AugmentedElement<'a'> {}

  // Install property augmentations onto ReactElement prop definitions
  namespace React {
    interface ButtonHTMLAttributes<T> extends AugmentedElement<'button'> {}
    interface LinkHTMLAttributes<T> extends AugmentedElement<'a'> {}
  }

  // Install Element/attribute augmentations into JSX definitions
  namespace JSX {
    interface IntrinsicElements extends AppBridgeElements {}
    interface IntrinsicAttributes extends AppBridgeAttributes {}
  }
}
