import { Command, Plugin } from '@oclif/core';
import Plugins from '../../plugins';
export default class PluginsInspect extends Command {
    static description: string;
    static usage: string;
    static examples: string[];
    static strict: boolean;
    static enableJsonFlag: boolean;
    static args: {
        plugin: import("@oclif/core/lib/interfaces/parser").Arg<string, Record<string, unknown>>;
    };
    static flags: {
        help: import("@oclif/core/lib/interfaces").BooleanFlag<void>;
        verbose: import("@oclif/core/lib/interfaces").BooleanFlag<boolean>;
    };
    plugins: Plugins;
    run(): Promise<Plugin[]>;
    parsePluginName(input: string): Promise<string>;
    findPlugin(pluginName: string): Plugin;
    inspect(pluginName: string, verbose?: boolean): Promise<Plugin>;
    findDep(plugin: Plugin, dependency: string): Promise<{
        version: string | null;
        pkgPath: string | null;
    }>;
}
