import * as Interfaces from './interfaces';
import { Config } from './config';
export declare const helpAddition: (argv: string[], config: Interfaces.Config) => boolean;
export declare const versionAddition: (argv: string[], config?: Interfaces.Config) => boolean;
export declare function run(argv?: string[], options?: Interfaces.LoadOptions): Promise<unknown>;
/**
 * Load and run oclif CLI
 *
 * @param options - options to load the CLI
 * @returns Promise<void>
 *
 * @example For ESM dev.js
 * ```
 * #!/usr/bin/env ts-node
 * // eslint-disable-next-line node/shebang
 * (async () => {
 *   const oclif = await import('@oclif/core')
 *   await oclif.execute({type: 'esm', development: true, dir: import.meta.url})
 * })()
 * ```
 *
 * @example For ESM run.js
 * ```
 * #!/usr/bin/env node
 * // eslint-disable-next-line node/shebang
 * (async () => {
 *   const oclif = await import('@oclif/core')
 *   await oclif.execute({type: 'esm', dir: import.meta.url})
 * })()
 * ```
 *
 * @example For CJS dev.js
 * ```
 * #!/usr/bin/env node
 * // eslint-disable-next-line node/shebang
 * (async () => {
 *   const oclif = await import('@oclif/core')
 *   await oclif.execute({type: 'cjs', development: true, dir: __dirname})
 * })()
 * ```
 *
 * @example For CJS run.js
 * ```
 * #!/usr/bin/env node
 * // eslint-disable-next-line node/shebang
 * (async () => {
 *   const oclif = await import('@oclif/core')
 *   await oclif.execute({type: 'cjs', dir: import.meta.url})
 * })()
 * ```
 */
export declare function execute(options: {
    type: 'cjs' | 'esm';
    dir: string;
    args?: string[];
    loadOptions?: Interfaces.LoadOptions;
    development?: boolean;
}): Promise<void>;
