import * as Errors from '../errors';
import { ActionBase } from './action/base';
import { config, Config } from './config';
import { ExitError } from './exit';
import { IPromptOptions } from './prompt';
import * as styled from './styled';
import { Table } from './styled';
import * as uxPrompt from './prompt';
import uxWait from './wait';
export declare class ux {
    static config: Config;
    static get prompt(): typeof uxPrompt.prompt;
    /**
     * "press anykey to continue"
     */
    static get anykey(): typeof uxPrompt.anykey;
    static get confirm(): typeof uxPrompt.confirm;
    static get action(): ActionBase;
    static get prideAction(): ActionBase;
    static styledObject(obj: any, keys?: string[]): void;
    static styledHeader(header: string): void;
    static get styledJSON(): typeof styled.styledJSON;
    static get table(): typeof styled.Table.table;
    static get tree(): typeof styled.tree;
    static get wait(): typeof uxWait;
    static get progress(): typeof styled.progress;
    static done(): Promise<void>;
    static trace(format: string, ...args: string[]): void;
    static debug(format: string, ...args: string[]): void;
    static info(format: string, ...args: string[]): void;
    static log(format?: string, ...args: string[]): void;
    static url(text: string, uri: string, params?: {}): void;
    static annotation(text: string, annotation: string): void;
    static flush(ms?: number): Promise<void>;
}
declare const action: ActionBase;
declare const annotation: typeof ux.annotation;
declare const anykey: typeof uxPrompt.anykey;
declare const confirm: typeof uxPrompt.confirm;
declare const debug: typeof ux.debug;
declare const done: typeof ux.done;
declare const error: typeof Errors.error;
declare const exit: typeof Errors.exit;
declare const flush: typeof ux.flush;
declare const info: typeof ux.info;
declare const log: typeof ux.log;
declare const prideAction: ActionBase;
declare const progress: typeof styled.progress;
declare const prompt: typeof uxPrompt.prompt;
declare const styledHeader: typeof ux.styledHeader;
declare const styledJSON: typeof styled.styledJSON;
declare const styledObject: typeof ux.styledObject;
declare const table: typeof styled.Table.table;
declare const trace: typeof ux.trace;
declare const tree: typeof styled.tree;
declare const url: typeof ux.url;
declare const wait: (ms?: number) => Promise<void>;
declare const warn: typeof Errors.warn;
export { action, ActionBase, annotation, anykey, config, Config, confirm, debug, done, error, exit, ExitError, flush, info, IPromptOptions, log, prideAction, progress, prompt, styledHeader, styledJSON, styledObject, table, Table, trace, tree, url, wait, warn, };
