"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useWinstonLogger = exports.setSilentLogger = exports.setLogger = exports.getLogger = void 0;
const ts_log_1 = require("ts-log");
let logger;
function getLogger() {
    return logger || ts_log_1.dummyLogger;
}
exports.getLogger = getLogger;
useWinstonLogger();
function setLogger(newLogger) {
    logger = newLogger;
}
exports.setLogger = setLogger;
function setSilentLogger() {
    logger = ts_log_1.dummyLogger;
}
exports.setSilentLogger = setSilentLogger;
function useWinstonLogger() {
    if (logger === null || logger === void 0 ? void 0 : logger.levels) {
        return;
    }
    logger = console;
}
exports.useWinstonLogger = useWinstonLogger;
